
 


; sample code



;	interrupt vectors for MC56F8006





	section interrupt_routines
	org	p:
	
MC56F8006_intRoutine:
	debughlt
	nop
	nop
	rti


; 2 - illegal instruction interrupt ($04)

MC56F8006_illegal:
	debughlt	
	nop
	nop
	rti


;3 -  hardware stack overflow interrupt ($06)
	
MC56F8006_HWSOverflow:
	debughlt	
	nop
	nop
	rti
	
	
; 4 - misaligned long word access interrupt ($08)
	
MC56F8006_misalign:
	debughlt	                     
	nop
	nop
	rti


 ; 11 - PLL losS of lock interrupt ($16)
 
MC56F8006_PLL:
	debughlt	                    
	nop
	nop 
	rti
    endsec
    
    
	section interrupt_vectors
	org	p:
	
	global	FMC56F8006_intVec

FMC56F8006_intVec:

	jsr >Finit_MC56F8006_        ; 00 RESET                                                ($00)
	jsr >MC56F8006_intRoutine    ; 01 COP Watchdog reset                                   ($02)
	jsr >MC56F8006_illegal       ; 02 illegal instruction                                  ($04)
	jsr >MC56F8006_HWSOverflow   ; 03 hardware stack overflow                              ($06)
	jsr >MC56F8006_misalign      ; 04 misaligned long word access                          ($08)
	jsr >MC56F8006_intRoutine    ; 05 EOnCE step counter                                   ($0A)
	jsr >MC56F8006_intRoutine    ; 06 EOnCE breakpoint unit 0                              ($0C)
	jsr >MC56F8006_intRoutine    ; 07 EOnCE trace buffer                                   ($0E)
	jsr >MC56F8006_intRoutine    ; 08 EOnCE transmit register empty                        ($10)
	jsr >MC56F8006_intRoutine    ; 09 EOnCE receive register full                          ($12)
	jsr >MC56F8006_intRoutine    ; 10 PMC Out Of Regulation                                ($14)
 	jsr >MC56F8006_PLL           ; 11 PLL OCCS LostLock 0-1,Loss ofRefereceClock           ($16)
	jsr >MC56F8006_intRoutine    ; 12 ADCA Conversion Complete                             ($18)
	jsr >MC56F8006_intRoutine    ; 13 ADCB Conversion Complete                             ($1A)
	jsr >MC56F8006_intRoutine    ; 14 PWM (Reload, Fault)                                  ($1C)
	jsr >MC56F8006_intRoutine    ; 15 CMP0 (Flag Rising, Flag Falling)                     ($1E)
	jsr >MC56F8006_intRoutine    ; 16 CMP1 (Flag Rising, Flag Falling)                     ($20)
	jsr >MC56F8006_intRoutine    ; 17 CMP2 (Flag Rising, Flag Falling)                     ($22)
 	jsr >MC56F8006_intRoutine    ; 18 HFM (Error, Command Complete, Buffer Empty)          ($24)
 	jsr >MC56F8006_intRoutine    ; 19 SPI (RX Full, RX Overflow, RX Mode Fault)            ($26)
 	jsr >MC56F8006_intRoutine    ; 20 SPI TX Empty                                         ($28)
 	jsr >MC56F8006_intRoutine    ; 21 SCI (TX Empty, TX Idle)                              ($2A)
 	jsr >MC56F8006_intRoutine    ; 22 SCI (RX Error, RX Full/Overrun)                      ($2C)
 	jsr >FIIC_SMBusIsr    ; 23 I2C (TX Complete, Match, Arb Lost, Timeout)          ($2E)
 	jsr >MC56F8006_intRoutine    ; 24 PIT                                                  ($30)
 	jsr >MC56F8006_intRoutine    ; 25 TMR0 (Compare, Overflow, Input Edge, Compare 1-2)    ($32)
 	jsr >MC56F8006_intRoutine    ; 26 TMR1 (Compare, Overflow, Input Edge, Compare 1-2)    ($34)
 	jsr >MC56F8006_intRoutine    ; 27 GPIOA                                                ($36)
 	jsr >MC56F8006_intRoutine    ; 28 GPIOB                                                ($38)
 	jsr >MC56F8006_intRoutine    ; 29 GPIOC                                                ($3A)
 	jsr >MC56F8006_intRoutine    ; 30 GPIOD                                                ($3C)
 	jsr >MC56F8006_intRoutine    ; 31 GPIOE                                                ($3E)
 	jsr >MC56F8006_intRoutine    ; 32 GPIOF                                                ($40)
 	jsr >MC56F8006_intRoutine    ; 33 Real Time Clock                                      ($42)
 	jsr >MC56F8006_intRoutine    ; 34 RESERVED                                             ($44)
 	jsr >MC56F8006_intRoutine    ; 35 RESERVED                                             ($46)
 	jsr >MC56F8006_intRoutine    ; 36 RESERVED                                             ($48)
 	jsr >MC56F8006_intRoutine    ; 37 RESERVED                                             ($4A)
 	jsr >MC56F8006_intRoutine    ; 38 RESERVED                                             ($4C)
 	jsr >MC56F8006_intRoutine    ; 39 RESERVED                                             ($4E)
  	jsr >MC56F8006_intRoutine    ; 40 SW Interrupt 0                                       ($50)
 	jsr >MC56F8006_intRoutine    ; 41 SW Interrupt 1                                       ($52)
 	jsr >MC56F8006_intRoutine    ; 42 SW Interrupt 2                                       ($54)
 	jsr >MC56F8006_intRoutine    ; 43 SW Interrupt 3                                       ($56)
 	jsr >MC56F8006_intRoutine    ; 44 SW Interrupt Low Priority                            ($58)
 	jsr >MC56F8006_intRoutine    ; 45 User Programmable L1 Interrupt                       ($5A)
 	jsr >MC56F8006_intRoutine    ; 46 User Programmable L1 Interrupt                       ($5C)
 	jsr >MC56F8006_intRoutine    ; 47 User Programmable L1 Interrupt                       ($5E)
 	jsr >MC56F8006_intRoutine    ; 48 User Programmable L2 Interrupt                       ($60)
 	jsr >MC56F8006_intRoutine    ; 49 User Programmable L2 Interrupt                       ($62)
 	jsr >MC56F8006_intRoutine    ; 50 User Programmable L2 Interrupt (or Fast Interrupt)   ($64)

	endsec	

	end


